######################################################
## Analysis gender inequality hypotheses (H3a, H3b) ##
######################################################

##
## LINEAR HYPOTHESIS (H3a)
##

# fertility
model.gender.linear1 <- clm(max_prev ~
                               # ethnic hatred
                               epr_ethwar + 
                               # state capacity
                               taxgdp.mwz + 
                               # military coherence
                               troop_quality_log.mwz + 
                               # feminist theory
                               wdi.fertility.mwz + 
                               # democratic peace theory
                               xpolity.mwz + 
                               # control variables
                               duration.mwz +
                               type_intrastate + type_internationalized + 
                               max_prev_lag.dummy + 
                               wdi.pop.density.log.mwz + mountain_log.mwz,
                             link="logit", data=states.active)

# Coefficients and summary statistics
summary(model.gender.linear1)
summary(model.gender.linear1)$coefficients
model.gender.linear1$nobs # Number of observations
exp(model.gender.linear1$coefficients) %>% data.frame() # Odd Ratios (in a data frame)
#exp(confint(model.dempeace.linear, type = "Wald")) # confidence intervals for OR with Wald statistic
logLik(model.gender.linear1)*-2        # -2 log-likelihood
AIC(model.gender.linear1)              # AIC
nagelkerke(model.gender.linear1$formula, states.active)

# political rights
model.gender.linear2 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wopol.mwz + 
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              max_prev_lag.dummy + 
                              wdi.pop.density.log.mwz + mountain_log.mwz,
                            link="logit", data=states.active)
summary(model.gender.linear2)
model.gender.linear2$nobs # Number of observations
logLik(model.gender.linear2)*-2        # -2 log-likelihood
nagelkerke(model.gender.linear2$formula, states.active)


# economical rights
model.gender.linear3 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wecon.mwz + 
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)
model <- model.gender.linear3
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)

# social rights
model.gender.linear4 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wosoc.mwz + 
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)
model <- model.gender.linear4
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)

##
## PARABOLIC HYPOTHESIS (H3b)
##


# fertility
model.gender.quadratic1 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              wdi.fertility.mwz + wdi.fertility.quadratic.mwz +
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)

# Coefficients and summary statistics
model <- model.gender.quadratic1
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)


# political rights
model.gender.quadratic2 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wopol.mwz + ciri_wopol.quadratic.mwz +
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)
model <- model.gender.quadratic2
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)


# economical rights
model.gender.quadratic3 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wecon.mwz + ciri_wecon.quadratic.mwz +
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)
model <- model.gender.quadratic3
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)


# social rights
model.gender.quadratic4 <- clm(max_prev ~
                              # ethnic hatred
                              epr_ethwar + 
                              # state capacity
                              taxgdp.mwz + 
                              # military coherence
                              troop_quality_log.mwz + 
                              # feminist theory
                              ciri_wosoc.mwz + ciri_wosoc.quadratic.mwz +
                              # democratic peace theory
                              xpolity.mwz + 
                              # control variables
                              duration.mwz +
                              type_intrastate + type_internationalized + 
                              wdi.pop.density.log.mwz + mountain_log.mwz +
                              max_prev_lag.dummy,
                            link="logit", data=states.active)
model <- model.gender.quadratic4
summary(model)
model$nobs # Number of observations
logLik(model)*-2        # -2 log-likelihood
nagelkerke(model$formula, states.active)

